<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/database.php';

// Get user ID from query parameter
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die();

$database = new Database();
$db = $database->getConnection();

try {
    // Get all pending messages for this user
    $query = "SELECT m.* 
              FROM messages m
              INNER JOIN message_queue mq ON m.id = mq.message_id
              WHERE mq.recipient_id = :user_id
              ORDER BY m.timestamp ASC";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $user_id);
    $stmt->execute();
    
    $messages = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $messages[] = [
            "server_message_id" => $row['id'],
            "local_message_id" => $row['local_message_id'],
            "sender_id" => $row['sender_id'],
            "conversation_id" => $row['conversation_id'],
            "content" => $row['content'],
            "message_type" => $row['message_type'],
            "timestamp" => $row['timestamp'],
            "is_edited" => $row['is_edited'] == 1
        ];
    }
    
    // Update user online status
    $update_query = "UPDATE users SET is_online = TRUE, last_seen = NOW() WHERE id = :user_id";
    $update_stmt = $db->prepare($update_query);
    $update_stmt->bindParam(":user_id", $user_id);
    $update_stmt->execute();
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "count" => count($messages),
        "messages" => $messages
    ]);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error: " . $e->getMessage()
    ]);
}
?>

