<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->user_id) && !empty($data->device_token)) {
    
    $database = new Database();
    $db = $database->getConnection();
    
    try {
        // Insert or update device token
        $query = "INSERT INTO device_tokens (user_id, device_token, platform, is_active)
                  VALUES (:user_id, :token, :platform, TRUE)
                  ON DUPLICATE KEY UPDATE 
                  is_active = TRUE, 
                  updated_at = NOW()";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(":user_id", $data->user_id);
        $stmt->bindParam(":token", $data->device_token);
        $platform = $data->platform ?? 'android';
        $stmt->bindParam(":platform", $platform);
        
        if ($stmt->execute()) {
            http_response_code(200);
            echo json_encode([
                "success" => true,
                "message" => "Device registered successfully"
            ]);
        }
        
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error: " . $e->getMessage()
        ]);
    }
}
?>

