<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->server_message_id) &&
    !empty($data->status) &&
    !empty($data->user_id)
) {
    
    $database = new Database();
    $db = $database->getConnection();
    
    try {
        // Update message status
        $status_field = $data->status . "_at";
        
        $query = "UPDATE messages 
                  SET status = :status, 
                      {$status_field} = NOW()
                  WHERE id = :msg_id AND recipient_id = :user_id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(":status", $data->status);
        $stmt->bindParam(":msg_id", $data->server_message_id);
        $stmt->bindParam(":user_id", $data->user_id);
        
        if ($stmt->execute()) {
            // If delivered, remove from queue
            if ($data->status == 'delivered') {
                $delete_query = "DELETE FROM message_queue 
                                WHERE message_id = :msg_id";
                $delete_stmt = $db->prepare($delete_query);
                $delete_stmt->bindParam(":msg_id", $data->server_message_id);
                $delete_stmt->execute();
            }
            
            // Get sender ID to notify
            $sender_query = "SELECT sender_id FROM messages WHERE id = :msg_id";
            $sender_stmt = $db->prepare($sender_query);
            $sender_stmt->bindParam(":msg_id", $data->server_message_id);
            $sender_stmt->execute();
            $sender = $sender_stmt->fetch(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode([
                "success" => true,
                "message" => "Status updated",
                "data" => [
                    "server_message_id" => $data->server_message_id,
                    "status" => $data->status,
                    "sender_id" => $sender['sender_id'],
                    "timestamp" => time() * 1000
                ]
            ]);
        } else {
            http_response_code(503);
            echo json_encode([
                "success" => false,
                "message" => "Unable to update status"
            ]);
        }
        
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error: " . $e->getMessage()
        ]);
    }
    
} else {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Missing required fields"
    ]);
}
?>

